use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- DEV-89719   Panel Script 69
IF NOT EXISTS (SELECT 1 FROM sys.columns WHERE [object_id] = OBJECT_ID(''[dbo].[PanelistVersionDatas]'') and [name] = ''TimeZone'')
BEGIN
    ALTER TABLE [dbo].[PanelistVersionDatas]
    ADD [TimeZone] NVARCHAR(MAX) NULL
END
'

declare @PanelClientPayload02 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_CreatePanelistVersion]'') AND type in (N''P'', N''	PC''))
   DROP PROCEDURE [dbo].[VX_sp_CreatePanelistVersion]
'

declare @PanelClientPayload03 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_CreatePanelistVersion]
	@panelistId int,
	@status int,
	@userId int
AS
BEGIN
	SET NOCOUNT ON
    DECLARE @enabled bit
	SELECT @enabled = p.EnableVersioning
	FROM Panels p
	INNER JOIN Panelists ps ON p.id = ps.Panel_Id
	WHERE ps.id = @panelistId

	IF @enabled = 1
	BEGIN
	    DECLARE @panelistVersionId AS INT
	    DECLARE @panelistVersionDataId AS INT
	    DECLARE @groups AS NVARCHAR(MAX)

	    SET @groups = STUFF((SELECT '', '' + Name FROM Groups g INNER JOIN PanelistGroup pg ON g.Id = pg.Groups_Id  WHERE pg.Panelists_Id = @panelistId FOR XML PATH ('''')), 1, 2, '''')

	    INSERT INTO PanelistVersions (PanelistId, Status, CreatedOn, CreatedBy) VALUES (@panelistId, @status, GETUTCDATE(), @userid)

	    SET @panelistVersionId = SCOPE_IDENTITY()

	    INSERT INTO PanelistVersionDatas (UserName, PasswordHash, Salt, FirstName, LastName, [Phone], Email, Gender, DateOfBirth, [Language], [TimeZone], IsAnonymized, Status, Groups, PanelistVersion_PanelistId, PanelistVersion_Id)
	    SELECT UserName, PasswordHash, Salt, FirstName, LastName, [Phone], Email, Gender, DateOfBirth, [Language], [TimeZone], IsAnonymized, Status, @groups, @panelistId, @panelistVersionId FROM Panelists WITH(NOLOCK) WHERE Id = @panelistId

	    SET @panelistVersionDataId = SCOPE_IDENTITY()

	    INSERT INTO PanelistVersionDataAttributes (PanelistVersionDataId, Name, Value)
	    SELECT @panelistVersionDataId, mdd.Name, ISNULL(pmd.Value, '''') FROM PanelistAttributes pmd WITH (NOLOCK)
	    INNER JOIN AttributeDefinitions mdd WITH(NOLOCK) ON pmd.AttributeDefinitionId = mdd.Id
	    WHERE pmd.PanelistId = @panelistId
    END
END
'

declare @PanelClientPayload04 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[VX_sp_CreatePanelistVersionByPanelId]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[VX_sp_CreatePanelistVersionByPanelId]
'

declare @PanelClientPayload05 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_CreatePanelistVersionByPanelId]
 @panelId INT,
 @userId INT,
 @status INT,
 @batchSize INT = 10000
AS
BEGIN
 DECLARE @enabled BIT
 DECLARE @tblPanelistVersion table(id INT, panelistId INT)
 DECLARE @tblPanelistVersionData table(id INT, panelistId INT)
 DECLARE @id_control INT = 0
 DECLARE @totalRecordsToUpdate INT
 DECLARE @updatedRecords INT = 0

 SELECT @enabled =EnableVersioning FROM Panels WITH(NOLOCK) WHERE id = @panelId

 IF @enabled = 1 AND @batchSize > 0
  BEGIN
  SELECT @totalRecordsToUpdate = COUNT(id), @id_control = ISNULL(Min(id), 0) FROM Panelists WITH (NOLOCK) WHERE Panel_Id = @panelId AND [Status] IN (0,6,7)

  WHILE (@totalRecordsToUpdate > @updatedRecords )
  BEGIN
   DELETE FROM @tblPanelistVersion
   DELETE FROM @tblPanelistVersionData

   INSERT INTO PanelistVersions (PanelistId, [Status], CreatedOn, CreatedBy)
   OUTPUT  inserted.Id, inserted.PanelistId INTO @tblPanelistVersion
   SELECT Id, @status, GETUTCDATE(), @userid FROM  Panelists WITH (NOLOCK)
   WHERE Panel_Id = @panelId AND [Status] in (0,6,7) AND id >= @id_control AND id < @id_control + @batchSize

   SET @updatedRecords = @updatedRecords + @@ROWCOUNT
   SET @id_control = @id_control + @batchSize

   INSERT INTO PanelistVersionDatas (UserName, PasswordHash, Salt, FirstName, LastName, [Phone], Email, Gender, DateOfBirth, [Language], [TimeZone], IsAnonymized, Status, Groups, PanelistVersion_PanelistId, PanelistVersion_Id)
   OUTPUT  inserted.Id, inserted.PanelistVersion_PanelistId INTO @tblPanelistVersionData
   SELECT UserName, PasswordHash, Salt, FirstName, LastName, [Phone], Email, Gender, DateOfBirth, [Language], [TimeZone],
   IsAnonymized, [Status],
   STUFF((SELECT '', '' + [Name] FROM Groups g INNER JOIN PanelistGroup pg ON g.Id = pg.Groups_Id  WHERE pg.Panelists_Id = p.id FOR XML PATH ('''')), 1, 2, ''''),
   p.id, pv.id
   FROM Panelists p WITH (NOLOCK)
   INNER JOIN @tblPanelistVersion pv ON p.id = pv.panelistId

   INSERT INTO PanelistVersionDataAttributes (PanelistVersionDataId, [Name], [Value])
   SELECT pvd.id, mdd.[Name], ISNULL(pmd.[Value], '''')
   FROM PanelistAttributes pmd WITH (NOLOCK)
   INNER JOIN AttributeDefinitions mdd WITH(NOLOCK) ON pmd.AttributeDefinitionId = mdd.Id
   INNER JOIN @tblPanelistVersionData pvd ON pvd.panelistId = pmd.PanelistId
  END
 END
END
'

declare @PanelClientPayload06 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[VX_sp_CreatePanelistVersionByPanelistIds]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[VX_sp_CreatePanelistVersionByPanelistIds]
'

declare @PanelClientPayload07 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_CreatePanelistVersionByPanelistIds]
 @panelId INT,
 @userId INT,
 @status INT,
 @tblPanelistIds AS PanelistIdList READONLY
AS
BEGIN
 DECLARE @enabled BIT
 DECLARE @tblPanelistVersion TABLE(id INT, panelistId INT)
 DECLARE @tblPanelistVersionData TABLE(id INT, panelistId INT)

 SELECT @enabled = EnableVersioning FROM Panels WITH(NOLOCK) WHERE id = @panelId

 IF ISNULL(@enabled, 0) = 1
  BEGIN

   INSERT  INTO PanelistVersions (PanelistId, [Status], CreatedOn, CreatedBy)
   OUTPUT  inserted.Id, inserted.PanelistId INTO @tblPanelistVersion
   SELECT  Id, @status, GETUTCDATE(), @userid
   FROM    Panelists a WITH (NOLOCK) INNER JOIN @tblPanelistIds b
   ON      a.id = b.panelistid AND Panel_Id = @panelId
   AND     [Status] IN (0,6,7)

   INSERT INTO PanelistVersionDatas (UserName, PasswordHash, Salt, FirstName, LastName, [Phone], Email, Gender, DateOfBirth, [Language], [TimeZone], IsAnonymized, Status, Groups, PanelistVersion_PanelistId, PanelistVersion_Id)
   OUTPUT  inserted.Id, inserted.PanelistVersion_PanelistId INTO @tblPanelistVersionData
   SELECT UserName, PasswordHash, Salt, FirstName, LastName, [Phone], Email, Gender, DateOfBirth, [Language], [TimeZone],
   IsAnonymized, [Status],
   STUFF((SELECT '', '' + [Name] FROM Groups g INNER JOIN PanelistGroup pg ON g.Id = pg.Groups_Id  WHERE pg.Panelists_Id = p.id FOR XML PATH ('''')), 1, 2, ''''),
   p.id, pv.id
   FROM Panelists p WITH (NOLOCK)
   INNER JOIN @tblPanelistVersion pv ON p.id = pv.panelistId

   INSERT INTO PanelistVersionDataAttributes (PanelistVersionDataId, [Name], [Value])
   SELECT pvd.id, mdd.[Name], ISNULL(pmd.[Value], '''')
   FROM   PanelistAttributes pmd WITH (NOLOCK) INNER JOIN AttributeDefinitions mdd WITH(NOLOCK)
   ON     pmd.AttributeDefinitionId = mdd.Id
   INNER JOIN @tblPanelistVersionData pvd
   ON    pvd.panelistId = pmd.PanelistId
 END
END
'

declare @PanelClientPayload08 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[VX_sp_DeletePanelistsByPanelistIds]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[VX_sp_DeletePanelistsByPanelistIds]
'

declare @PanelClientPayload09 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_DeletePanelistsByPanelistIds]
 @panelId INT,
 @panelistIds [dbo].[PanelistIdList] READONLY
AS
BEGIN
    DELETE p
    FROM @panelistIds ids
    INNER JOIN [dbo].[Panelists] p
        ON ids.[PanelistId] = p.[Id]
        AND p.[Panel_Id] = @panelId
        AND p.[Status] IN (0,6,7);
END
'

declare @PanelClientPayload10 nvarchar(max) = N'
-- DEV-89744
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[VX_sp_AttributePanelistRewardByPanelistIds]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[VX_sp_AttributePanelistRewardByPanelistIds]
'

declare @PanelClientPayload11 nvarchar(max) = N'
Create PROCEDURE [VX_sp_AttributePanelistRewardByPanelistIds]
@panelId INT,
@source TINYINT,
@sourceId   INT,
@operation TINYINT,
@amount INT,
@message NVARCHAR(MAX),
@userId INT,
@panelistIds [dbo].[PanelistIdList] READONLY
AS
BEGIN
    DECLARE @UpdatedRecords INT = 0
    DECLARE @TotalExecuteRecord INT = 0
    DECLARE @NonExecuteRecord INT = 0

    IF EXISTS(SELECT TOP 1 1 FROM @panelistIds)
    BEGIN
	    --Get panelist whose current point are less incase of debit operation
	    IF @operation = 1
	    BEGIN
			    SELECT	@NonExecuteRecord = COUNT(1)
			    FROM	Panelists A WITH (NOLOCK) INNER JOIN @panelistIds B
			    ON		A.Id = B.PanelistId
			    AND 	Panel_Id = @panelId
			    AND		[Status] in (0,6,7)
			    AND		Points < @amount
	    END

	    INSERT INTO PointsTransactions(Source, SourceId, Operation, Amount, Message, CreatedBy, CreatedOn, PanelistId)
	    SELECT @source, @sourceId, @operation, @amount, @message, @userId, GETUTCDATE(), Id
	    FROM Panelists A WITH (NOLOCK) INNER JOIN @panelistIds B
	    ON	A.Id = B.PanelistId AND Panel_Id = @panelId
	    AND [Status] in (0,6,7)
	    AND ((@operation = 1 AND  Points >= @amount) OR    @operation = 0)


	    UPDATE A
	    SET    Points = CASE WHEN @operation = 1 THEN Points - @amount
					    ELSE Points + @amount END
	    FROM	Panelists A WITH (NOLOCK) INNER JOIN @panelistIds B
	    ON		A.Id = B.PanelistId AND Panel_Id = @panelId
	    AND     [Status] in (0,6,7)
	    AND     ((@operation = 1 AND  Points >= @amount) OR  @operation = 0)

	    SET @UpdatedRecords = @UpdatedRecords + @@ROWCOUNT
    END

    SELECT @updatedRecords ''TotalAffectedRecords'', @NonExecuteRecord ''NonExecutedRecord''
END
'

declare @PanelClientPayload12 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[VX_sp_AnonymizePanelistByPanelistIds]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[VX_sp_AnonymizePanelistByPanelistIds]
'

declare @PanelClientPayload13 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_AnonymizePanelistByPanelistIds]
 @panelId INT,
 @userId INT,
 @panelistIds [dbo].[PanelistIdList] READONLY
AS
BEGIN
    DECLARE @tblPanelist table(id INT)

    DECLARE @status INT = 6;
    DECLARE @AnonymizedChangeStatus INT = 4;
    DECLARE @email VARCHAR(50) = ''anonymous@anonymous.com'';
    DECLARE @phone VARCHAR(50) = ''555-555-5555'';

    IF EXISTS(SELECT TOP 1 1 FROM @panelistIds)
    BEGIN
	    --panelist versioning
	    EXEC dbo.[VX_sp_CreatePanelistVersionByPanelistIds] @panelId, @userId, @AnonymizedChangeStatus, @panelistIds

	    --Fetch AttributeDefination into temp
	    SELECT [Id], [Name]
	    INTO    #AttributeDefinitions
	    FROM    [dbo].[AttributeDefinitions]
	    WHERE PanelId = @panelId AND IsAnonymizable = 1

	    UPDATE A
	    SET    FirstName = LTRIM(RTRIM(STR(Id))),
			    LastName = LTRIM(RTRIM(STR(Id))),
			    Email = @email,
			    Phone = @phone,
			    IsAnonymized = 1,
			    ModifiedOn = GETUTCDATE(),
			    ModifiedBy = 0,
			    [Status] = @status
	    OUTPUT inserted.id INTO @tblPanelist
	    FROM  [dbo].[Panelists] A  INNER JOIN @panelistIds B
	    ON	A.Id = B.PanelistId  AND  Panel_Id = @panelId
	    AND   [Status] IN (0,6,7)

	    UPDATE pa
	    SET    pa.[Value] = '''',
			    pa.ImportValue = '''',
			    pa.ModifiedBy = @userId,
			    pa.ModifiedOn = GETUTCDATE()
	    FROM   [dbo].[PanelistAttributes] pa INNER JOIN @tblPanelist p
	    ON     pa.PanelistId = p.id
	    AND    pa.AttributeDefinitionId IN (SELECT Id FROM #AttributeDefinitions)

	    UPDATE pvd
	    SET    pvd.FirstName = LTRIM(RTRIM(STR(PanelistVersion_PanelistId))),
			    pvd.LastName = LTRIM(RTRIM(STR(PanelistVersion_PanelistId))),
			    pvd.Email = @email,
			    pvd.Phone = @phone,
			    pvd.IsAnonymized = 1,
			    pvd.[Status] = @status
	    FROM   [dbo].[PanelistVersionDatas] pvd INNER JOIN @tblPanelist p
	    ON     pvd.PanelistVersion_PanelistId = p.id

	    UPDATE [dbo].[PanelistVersionDataAttributes]
	    SET    [Value] = ''''
	    Where   PanelistVersionDataId IN (
									    SELECT pvd.Id
									    FROM   [dbo].[PanelistVersionDatas] pvd INNER JOIN @tblPanelist p
									    ON     pvd.PanelistVersion_PanelistId = p.id
									    )
	    AND    [Name] IN (SELECT [Name] FROM #AttributeDefinitions)

	    --Cannot set ModificationDateTime since it is a primary key
	    UPDATE paml
	    SET    paml.OldValue = '''',
			    paml.NewValue = '''',
			    paml.ModifiedBy = @userId
	    FROM  [dbo].[PanelistAttributeModifLogs] paml INNER JOIN @tblPanelist p
	    ON    paml.PanelistId = p.id
	    AND   AttributeId IN (SELECT Id FROM #AttributeDefinitions)

	    UPDATE pml
	    SET    pml.OldValue =   CASE pml.FieldName
			    When ''FirstName'' THEN LTRIM(RTRIM(STR(pml.PanelistId)))
			    When ''LastName''  THEN LTRIM(RTRIM(STR(pml.PanelistId)))
			    When ''Phone''     THEN @phone
			    When ''Email''     THEN @email
			    When ''Status''    THEN LTRIM(RTRIM(STR(@status)))
			    END,
	    pml.NewValue =  CASE FieldName
		    When ''FirstName'' THEN LTRIM(RTRIM(STR(pml.PanelistId)))
		    When ''LastName''  THEN LTRIM(RTRIM(STR(pml.PanelistId)))
		    When ''Phone''     THEN @phone
		    When ''Email''     THEN @email
		    When ''Status''    THEN LTRIM(RTRIM(STR(@status)))
		    END
	    FROM [dbo].[PanelistModifLogs] pml INNER JOIN @tblPanelist p
	    ON   pml.PanelistId = p.id
    END
END
'

declare @PanelClientPayload14 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[VX_sp_ChangePanelistsStatusByPanelistIds]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[VX_sp_ChangePanelistsStatusByPanelistIds]
'

declare @PanelClientPayload15 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_ChangePanelistsStatusByPanelistIds]
 @panelId int,
 @status int,
 @userId int,
 @panelistIds [dbo].[PanelistIdList] READONLY
AS
BEGIN
    DECLARE @panelistVersionStatus INT = 2   --PanelistVersionChange Enum modified value

    IF EXISTS(SELECT TOP 1 1 FROM @panelistIds)
    BEGIN
	    EXEC dbo.[VX_sp_CreatePanelistVersionByPanelistIds] @panelId, @userId, @panelistVersionStatus, @panelistIds

	    UPDATE  A
			    SET [Status] = @status,
			    ModifiedOn = GETUTCDATE(),
			    ModifiedBy = @userId,
			    ConfirmedOn = CASE WHEN ConfirmedOn is null THEN GETUTCDATE() ELSE ConfirmedOn END
	    FROM    Panelists A INNER JOIN @panelistIds B
	    ON		A.ID = B.PanelistId
	    AND		A.Panel_Id = @panelId
	    AND		A.[Status] in (0,6,7)
    END
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		print 'Panel Client Payload 1'
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 2'
		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 3'
		select @SQL = replace(replace(@PanelClientPayload03, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 4'
		select @SQL = replace(replace(@PanelClientPayload04, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 5'
		select @SQL = replace(replace(@PanelClientPayload05, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 6'
		select @SQL = replace(replace(@PanelClientPayload06, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 7'
		select @SQL = replace(replace(@PanelClientPayload07, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 8'
		select @SQL = replace(replace(@PanelClientPayload08, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 9'
		select @SQL = replace(replace(@PanelClientPayload09, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 10'
		select @SQL = replace(replace(@PanelClientPayload10, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 11'
		select @SQL = replace(replace(@PanelClientPayload11, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 12'
		select @SQL = replace(replace(@PanelClientPayload12, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 13'
		select @SQL = replace(replace(@PanelClientPayload13, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 14'
		select @SQL = replace(replace(@PanelClientPayload14, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 15'
		select @SQL = replace(replace(@PanelClientPayload15, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Panel Client Payload done for panel client ' + @ThisPanelClient + '!'

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
